d("miniCartView",['ccrz', 'util'], function(CCRZ, UTIL) {
    return {
        extendMiniCartView: function() {
            CCRZ.pubSub.on('view:cartView:refresh', function(cartView){
                disableItems(false);
                cartView.events['click #btnContinueShopping'] = 'closeMiniCart';
                cartView.events['change .input-text.entry'] = 'customQuantityChange';
                cartView.events['click .updateCartButton'] = 'handleUpdateCart';
                cartView.closeMiniCart = function(event){
                    $('#sidebar').removeClass('active'); // hide sidebar
                    $('#sidebarBackdrop').addClass('hide'); // hide overlay     
                };
                cartView.handleUpdateCart = function(event){
                    disableItems(true);
                    let reqData = { 'cartEncId' : CCRZ.pagevars.currentCartID }, cartItemIds = new Set();
                    let cartItemData = (CCRZ.cartView.cartmodel.attributes.cartItems)?CCRZ.cartView.cartmodel.attributes.cartItems:[];
                    if(cartItemData && cartItemData.length){
                        cartItemData.forEach(function(cartItem){
                            if(cartItem.quantity == 0){
                                cartItemIds.add(cartItem.itemID);
                            }
                        });
                    }
                    if(cartItemIds.length > 0){
                        reqData['cartItemIds'] = cartItemIds;
                        CCRZ.remoteModel.removeItems(JSON.stringify(reqData),function(res){
                            if(res && res.success){
                                cartView.saveCart(event);
                            } else {
                                // Error on controller
                                console.log('ERROR: Getting Related Products');
                            }
                        });
                    } else {
                        cartView.saveCart(event);
                    }
                };
                cartView.customQuantityChange = function(event){
                    disableItems(true);
                    let qty = parseInt(event.currentTarget.value), sku = event.currentTarget.dataset.sku, uom = event.currentTarget.dataset.uom;
                    if(qty < 0){
                        qty = 0;
                    }
                    if(uom == ''){
                        uom = 'Yearly';
                    }
                    let reqData = { 'cartEncId' : CCRZ.pagevars.currentCartID, 'prodSKU' : sku };
                    let cartItemData = (CCRZ.cartView.cartmodel.attributes.cartItems)?CCRZ.cartView.cartmodel.attributes.cartItems:[];
                    CCRZ.remoteModel.getRelatedProducts(JSON.stringify(reqData),function(res,evt){
                        if(res && res.success && res.data && res.data.length > 0){
                            if(cartItemData && cartItemData.length){
                                cartItemData.forEach(function(cartItem, index){
                                    res.data.forEach(function(skuData){
                                        if(skuData == cartItem.mockProduct.sku){
                                            if(cartItem.showSubProdTerm){
                                                if((!cartItem.subProdTermR.installmentFrequencyUOM && uom != 'Monthly') || (cartItem.subProdTermR.installmentFrequencyUOM && cartItem.subProdTermR.installmentFrequencyUOM == uom)){
                                                    $('#qtyInput_' + cartItem.itemID).val(qty);
                                                    cartItem.quantity = qty;
                                                }
                                            } else {
                                                $('#qtyInput_' + cartItem.itemID).val(qty);
                                                cartItem.quantity = qty;
                                            }
                                        }
                                    });
                                });
                            }
                        } else {
                            // Error on controller
                            console.log('ERROR: Getting Related Products');
                        }
                        disableItems(false);
                    });
                };
                cartView.delegateEvents();
            });  
            function disableItems(isDisable){
                $('.loggedInAction').prop('disabled', isDisable);
                $('.updateCartButton').prop('disabled', isDisable);
                $('.quantity input').prop('disabled', isDisable);
            }
        }
    }
});