d("productListPageView",['util',], function(UTIL,productListPageView) {

    return {

        extendproductListPageView: function() {
                CCRZ.productListPageViewWasRendered = false;
                CCRZ.pubSub.on("view:productListPageView:refresh", function(view) {
                    $('.productListContent').addClass('all-products-list');
                    CCRZ.productListPageViewWasRendered = true;
                    CCRZ.productListPageView.model.set('layout', "grid");
                    CCRZ.productListPageView.model.set('pageSize', 75);
                    CCRZ.productListPageView.headerView.setElement(CCRZ.uiProperties.productListPageView.header.selector);
                    CCRZ.productListPageView.productItemsView.setElement(CCRZ.uiProperties.productListPageView.productItems.selector);
                    CCRZ.productListPageView.footerView.setElement(CCRZ.uiProperties.productListPageView.footer.selector);
                    if(_.isUndefined(CCRZ.pagevars.queryParams['search'])){
                        CCRZ.hideLoader();
                    }
                });
                CCRZ.pubSub.on("view:productListFilterView:refresh", function(filterView) {
                    filterView.specGroupsView.setElement(CCRZ.uiProperties.productListFilterView.ListView.selector);
                    //On load fix for UI Slider (Wordaround)
                    setTimeout(function(){
                        filterView.specGroupsView.postRender();
                    }, 1000);
                });
                CCRZ.pubSub.on("view:productListHeader:refresh", function(prodHeaderView) {
                    prodHeaderView.events["click .cc_remove_filters"] = 'removeAllFilters';
                    prodHeaderView.removeAllFilters = function(event){
                        CCRZ.pubSub.trigger("view:" + this.viewName + ":removeAllFilters");
                        setTimeout(function(){
                            CCRZ.productListFilterView.specGroupsView.postRender();
                        }, 1500);
                    }
                    prodHeaderView.delegateEvents();
                });
                CCRZ.pubSub.on("action:productsPageRenderAllViews", function() {
                    CCRZ.productListPageView.render();
                    CCRZ.productListPageView.headerView.render();
                    CCRZ.productListFilterView.specGroupsView.render(); /// Add it for  for Product Specs
                    CCRZ.productListPageView.productItemsView.render();
                    CCRZ.productListPageView.footerView.render();
                });
                // Product Items view
                let isRefreshItemsView = false;
                CCRZ.pubSub.on("view:productItemsView:refresh", function(itemsView) {
                    if(!isRefreshItemsView){
                        let newItemsView = [], currentDate = new Date();
                        itemsView.events['click .addToWishList'] = 'handleWishListPicker';
                        itemsView.handleWishListPicker = function(event){
                            event.preventDefault();
                            let id = event.currentTarget.dataset.id;
                            $('#addToWish_' + id).modal({backdrop: true, show: true}); 
                            $('#addToWish_' + id).removeClass('fade');
                            $('.modal-backdrop').removeClass('fade');
                            this.pickerView.render();
                            runDefaultJsFunctions();
                        };
                        itemsView.postRender = function(){
                            if(this.pickerView){
                                this.pickerView.render(true);
                            }
                            runDefaultJsFunctions();
                            CCRZ.productListPageView.headerView.render();
                        };
                        itemsView.addProductView = function(product){
                            if(!_.isUndefined(CCRZ.productListPageModel.get('productPricingData')) && !_.isUndefined(CCRZ.productListPageModel.get('productPricingData')[product.get('sfid')])){
                             product.set('productPricingData', CCRZ.productListPageModel.get('productPricingData')[product.get('sfid')]);
                             delete CCRZ.productListPageModel.get('productPricingData')[product.get('sfid')];
                            }
                            if(_.isUndefined(product.attributes.CHVACNewPurchaseSunsetDate) || (new Date(product.attributes.CHVACNewPurchaseSunsetDate) > currentDate) || UTIL.isCSRFlow()){
                                this.itemViews.push(new CCRZ.views.ProductItemView({model: product}));
                            }
                            CCRZ.productListPageView.headerView.model.attributes.prodCount = CCRZ.productListPageView.productItemsView.itemViews.length;
                            CCRZ.productListPageView.model.attributes.prodCount = CCRZ.productListPageView.productItemsView.itemViews.length;
                        };
                        if(itemsView.itemViews.length > 0){
                            itemsView.itemViews.forEach(function(item){
                                if(_.isUndefined(item.model.attributes.CHVACNewPurchaseSunsetDate) || (new Date(item.model.attributes.CHVACNewPurchaseSunsetDate) > currentDate) || UTIL.isCSRFlow()){
                                    newItemsView.push(item);
                                }
                            });
                            itemsView.itemViews = newItemsView;
                            CCRZ.productListPageView.headerView.model.set('prodCount', newItemsView.length);
                            CCRZ.productListPageView.headerView.model.set('renderedCount', newItemsView.length);
                            CCRZ.productListPageView.headerView.model.set('noResults', (newItemsView.length > 0)?false:true);
                            CCRZ.productListPageView.headerView.render();
                            itemsView.render();
                        }
                        isRefreshItemsView = true;
                        itemsView.delegateEvents();
                    }
                });
                CCRZ.pubSub.on("view:productItemView:refresh", function(itemView) {
                    itemView.addToCart = function(event){
                        var qtyInput = $("#" + this.model.get('sfid') + "_qtyEntry");
                        var qty = qtyInput.val();
                        var productId = this.model.get('sfid');
                        var sellerId = !_.isUndefined(this.model.get('sellerID')) ? this.model.get('sellerID') : '';
                   
                        var incr = parseInt(this.model.get('qtySkipIncrement'));
                        var scrubbedQty = CCRZ.util.scrubQuantity(qty, incr);
                        if(qty !== scrubbedQty || qty < 1) {
                         CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-item-Error", 'Invalid_Qty'));
                         $('html, body').animate({
                            'scrollTop' : $(".messagingSection-item-Error").position().top
                         });
                         qtyInput.val(scrubbedQty);
                        } else {
                         this.className = 'cc_RemoteActionController';
                         this.processAddItem(productId,qty,sellerId);
                        }
                    };
                    itemView.delegateEvents();
                });
                let isWLRefresh = false;
                // Wishlist Picker Modal View
                CCRZ.pubSub.on("view:wishlistPickerModal:refresh", function(view) {
                    if(!isWLRefresh){
                        view.render = function(isMain) {
                            this.setElement($(CCRZ.uiProperties.wishlistPickerModal.selector));
                            var v = this;
                            if (CCRZ.display.isPhone()){
                                v.$el.html(v.templatePhone(this.coll.toJSON()));
                            }else{
                                v.$el.html(v.templateDesktop(this.coll.toJSON()));
                            }
                            runDefaultJsFunctions();
                            if(!isMain || typeof isMain == 'undefined'){
                                if(_.isUndefined(CCRZ.pagevars.queryParams['search'])){
                                    CCRZ.hideLoader();
                                }
                            }
                            CCRZ.pubSub.trigger("view:"+this.viewName+":refresh", this);
                        };
                        view.addItem = function(event) {
                            var objLink = $(event.target), parentObj = objLink.closest('.wishFinder'), newName = $(event.target.parentElement.previousElementSibling).find('.newListName').val();
                            var id = objLink.data("id"), type= objLink.data("type");
                            debugger;
                            if(type == 'select' || (id == '-1')){
                                this.processAddItem(parentObj, id, newName);
                            } else {
                                CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-Error-WL", 'Add a name before adding a wishlist!'));
                                setTimeout(function(){
                                    $('.messagingSection-Error-WL').css('display', 'none');
                                }, 3000);
                            }
                        };
                        view.processAddItem = function(parentObj, val, newName) {
                            CCRZ.showLoader();
                            var sku = parentObj.data("sku");
                            var v = this;
                            this.invokeContainerLoadingCtx($('.deskLayout'), 'handleAddtoWishlist', sku, val, newName, function(response) {
                                CCRZ.pubSub.trigger('refreshWishlists', val);
                                if (val == '-1') {
                                    CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('INFO', "messagingSection-Info-WL", 'New Wishlist has been created: ' + newName));
                                v.refresh();
                                } else {
                                    CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('INFO', "messagingSection-Info-WL", 'Product added to the Wishlist!'));
                                    CCRZ.hideLoader();
                                }
                                setTimeout(function(){
                                    $('.messagingSection-Info-WL').css('display', 'none');
                                }, 3000);
                            });
                        };
                        view.delegateEvents();
                        isWLRefresh = true;
                        view.render(true);
                    }
                });
                //Slider value Change fix for UI Slider (Wordaround)
                CCRZ.pubSub.on("view:specGroupView:refresh", function(filterView) {
                    filterView.events["update .cc_slider"] = 'performRangeFilter';
                    filterView.events["click .cc_filter_checkbox"] = 'toggleSelected';
                    filterView.events["click .cc_collapse_group"] = 'toggleCollapseCustom';
                    filterView.toggleCollapseCustom = function(event, values){
                        var objLink = $(event.currentTarget);
                        var id = objLink.data('target');
                        var $element = $(id);
                        if(this.model.get('collapsed')){
                            //$element.removeClass('show');
                        } else {
                            //$element.addClass('show');
                        }
                        $element.collapse('toggle')
                        this.model.set('collapsed', !this.model.get('collapsed'), {silent: true});
                    };
                    filterView.performRangeFilter = function(event, values){
                        var objLink = $(event.currentTarget);
                        this.model.set('filterMin', values[0], {silent: true});
                        this.model.set('filterMax', values[1], {silent: true});
                        var filter = _.pick(this.model.toJSON(), 'sfid', 'name', 'filterType', 'filterMin', 'filterMax');
                    
                        CCRZ.appliedFilters.set(filter, {parse: false, remove: false, merge: true});
                        if (CCRZ.ga) {
                            CCRZ.ga.handleFeatureFilter(objLink);
                        }
                        CCRZ.pubSub.trigger("view:productListFilterView:applyFilters", CCRZ.appliedFilters);
                        //UI Silder render on changing values, timeout for workaround to fix UI silder
                        setTimeout(function(){
                            CCRZ.productListFilterView.specGroupsView.postRender();
                        }, 1500);
                    };
                    filterView.toggleSelected = function(event){
                        var objLink = $(event.currentTarget);
                        var filter = _.pick(this.model.toJSON(), 'sfid', 'name', 'filterType');

                        var specGroupValues = this.model.get('specValues');
                        var toUpdate = specGroupValues.find({value: objLink.attr("data-value")});
                        toUpdate.set('selected', objLink.is(':checked'));

                        var appliedFilters = _.where(specGroupValues.toJSON(), {selected: true});
                        if(appliedFilters.length != 0){
                        filter.specValues = appliedFilters;
                        CCRZ.appliedFilters.set(filter, {parse: false, remove: false, merge: true});
                        }else{
                        CCRZ.appliedFilters.remove(filter);
                        }
                        if (CCRZ.ga && objLink.is(':checked')) {
                        CCRZ.ga.handleFeatureFilter(objLink);
                        }
                        CCRZ.pubSub.trigger("view:productListFilterView:applyFilters", CCRZ.appliedFilters);
                        setTimeout(function(){
                            CCRZ.productListFilterView.specGroupsView.postRender();
                        }, 2000);
                    };
                    filterView.delegateEvents();
                });
            }
            
    }
});

