d("paymentPOView",['util', 'paymentPOModel'], function(UTIL, paymentPOModel) {

    return {
        extendPaymentPOView: function() {
            let response = {};
            response['success'] = false;
            response['message'] = CCRZ.pagevars.pageLabels.ALTB2B_po_uploadWarning;
            CCRZ.views.paymentPOView = CCRZ.CloudCrazeView.extend({
                viewName: "paymentPOView",
                managedSubView: true,
                templateDesktop: CCRZ.util.template(CCRZ.uiProperties.paymentPOView.desktop.tmpl),
                templatePhone: CCRZ.util.template(CCRZ.uiProperties.paymentPOView.desktop.tmpl),
                init: function(options) {
                    this.selector = options.selector;
                    this.render();
                    CCRZ.pubSub.trigger('action:paymentViewInit', this);
                },
                parentPreRender: function() {
                    //Look for the instantiated iframe
                    //Detach it from the DOM
                    //Re-render the view but dont create the iframe
                    //Re-attach the iframe as appropriate in the rendered view
                },
                renderDesktop: function() {
                    this.setElement(this.selector);
                    this.data = {};
                    this.$el.html(this.templateDesktop(this.data));
                },
                renderPhone: function() {
                    this.setElement(this.selector);
                    this.data = {};
                    this.$el.html(this.templatePhone(this.data));
                },
                events : {
                    'click #submitPOBtn' : 'handleSubmit',
                    'change #termsdisclaimer' : 'handleChangeTerms',
                    'change #po-file' : 'handleFileChange',
                },
                handleSubmit : function(event){
                    let _this = this;
                    $('#sidebarBackdropCustom').removeClass('hide');  
                    var termsPay = document.getElementById('termsdisclaimer').checked;
                    //po field
                    var poOrderNo = document.getElementById('po-orderno');
                    var poOrderName = document.getElementById('po-ordername');
                    
                    _this.removePOFileValidation(document.getElementById('po-file'), document.getElementById('po-error-text'));
                    
                    UTIL.hideValidate(poOrderNo);
                    UTIL.hideValidate(poOrderName);
                    
                    //terms fields
                    let termsFullName = document.getElementById('terms-fullname');
                    UTIL.hideValidate(termsFullName);
                    
                    if(termsPay){
                        //Terms payment scenario
                        if(termsFullName.value){
                            //call to setup and initiate payment
                            _this.processPOPayment('',termsFullName.value,'','',true, _this);
                        }else{
                            //add validation
                            UTIL.showValidate(termsFullName);
                            $('#sidebarBackdropCustom').addClass('hide');
                        }
                    }else{
                        //PO payment scenario
                        var valid = true;
                        
                        if(poOrderNo.value && poOrderName.value && response['success']){
                            //call to setup and initiate payment
                            _this.processPOPayment(poOrderNo.value,poOrderName.value,response['file'],response['filename'],false, _this);
                        }else{
                            valid = false;
                            //add validation
                            if(!poOrderNo.value){
                                UTIL.showValidate(poOrderNo);
                            }
                            if(!poOrderName.value){
                                UTIL.showValidate(poOrderName);
                            }
                            if(!response['success']){
                                _this.addPOFileValidation(document.getElementById('po-file'), document.getElementById('po-error-text'),response['message']);
                            }
                            $('#sidebarBackdropCustom').addClass('hide');
                        }
                    }
                },
                handleChangeTerms : function(event){
                    var termsPay = document.getElementById('termsdisclaimer').checked;
                    var poBlock = document.getElementsByClassName('po-block')[0];
                    var poOrderNo = document.getElementById('po-orderno');
                    var poOrderName = document.getElementById('po-ordername');
                    var file = document.getElementById('po-file');
                    
                    if(termsPay){
                        poBlock.style.opacity = '0.3';
                        poOrderNo.setAttribute('disabled',true);
                        poOrderName.setAttribute('disabled',true);
                        file.setAttribute('disabled',true);
                    }else{
                        poBlock.style.opacity = '1';
                        poOrderNo.removeAttribute('disabled');
                        poOrderName.removeAttribute('disabled');
                        file.removeAttribute('disabled');
                    }
                },
                handleFileChange : function(){
                    let _this = this;
                    _this.removePOFileValidation(document.getElementById('po-file'), document.getElementById('po-error-text'));
                    response['success'] = false;
                    response['message'] = CCRZ.pagevars.pageLabels.ALTB2B_po_uploadError;
                    
                    var file = document.getElementById('po-file').files[0];
                    
                    var allowedFileTypes = document.getElementById('poFileTypes').value;
                    var fileTypeArray = [];
                    
                    if(allowedFileTypes){
                        allowedFileTypes = allowedFileTypes.replace(/\./g,'');
                        
                        fileTypeArray = allowedFileTypes.split(',');
                        
                    }
                    var allowedSize = 4 * 1024 * 1024;
                    
                    if(file){
                    
                        var fileExts = file.name.split(/\.(?=[^\.]+$)/);
                        
                        if(fileExts.length > 1 && fileTypeArray.includes(fileExts[1])){
                        
                            if(file.size < allowedSize){                        
                                // create reader
                                var reader = new FileReader();
                                
                                reader.onload = function(e) {
                                    // browser completed reading file - display it
                                    response['success'] = true;
                                    response['file'] = e.target.result.split('base64,')[1];
                                    response['filename'] = file.name;
                                    response['message'] = '';
                                }
                                reader.readAsDataURL(file);
                            }else{
                                response['message'] = CCRZ.pagevars.pageLabels.ALTB2B_po_uploadLimit;
                                _this.addPOFileValidation(document.getElementById('po-file'), document.getElementById('po-error-text'), response['message']);
                            }
                        }else{
                            response['message'] = CCRZ.pagevars.pageLabels.ALTB2B_po_uploadAllowed1 +allowedFileTypes + CCRZ.pagevars.pageLabels.ALTB2B_po_uploadAllowed2;
                            _this.addPOFileValidation(document.getElementById('po-file'), document.getElementById('po-error-text'), response['message']);
                        }
                    }
                },
                processPOPayment : function(poNumber,poName,file,filename,isTerms, _this){
                    _this.model.submitPayment(poNumber,poName,file,filename,isTerms, function(response, event){
                        if(event.status){                
                            if(response.success){                    
                                $.alert({
                                    title: document.getElementById('poSuccessHeading').value,
                                    content: document.getElementById('poSuccessMsg').value
                                });
                                _this.processTransactionPayment(response.data['txObject']);
                            }else{
                                _this.displayErrorMsg();
                            }
                        }else{
                            _this.displayErrorMsg();
                        }
                    });
                },
                processTransactionPayment : function(transactionPayment){
                    setTimeout(function() {
                        CCRZ.pubSub.trigger('action:processPayment', transactionPayment);
                    }, 3000);
                },
                displayErrorMsg : function(){
                    $.alert({
                        title: document.getElementById('poErrorHeading').value,
                        content: document.getElementById('poErrorMsg').value
                    });
                    $('#sidebarBackdropCustom').addClass('hide');
                },
                removePOFileValidation: function(poFile, poFileErrTxt){
                    poFileErrTxt.innerText = '';
                    poFile.style.border = '0px';
                },
                addPOFileValidation: function(poFile, poFileErrTxt, message){
                    poFile.style.border = '1px solid #c9341c';
                    poFileErrTxt.innerText = message;
                },
            });
            CCRZ.pubSub.trigger('action:paymentViewReady', 'po', function(options) {
                //need som info cart ID
                CCRZ.payment = CCRZ.payment || {
                    views: {}
                };
                CCRZ.payment.views.po = new CCRZ.views.paymentPOView({
                    model: new paymentPOModel(),
                    selector: options.selector
                });
            });
        } 
    }
});