d("footerView",['util'], function(util) {

    return {
        extendFooterView: function() {
            // Create Custom Footer View
            CCRZ.views.footerView = CCRZ.CloudCrazeView.extend({
                el: CCRZ.uiProperties.footer.selector,
                viewName: "customFooterView",
                template: CCRZ.util.template(CCRZ.uiProperties.footer.tmpl),
                init: function(){
                    this.render();
                },
                render: function(){
                    this.$el.html(this.template);
                }
            });
    
            if(window.location.href.indexOf('ChangePassword') > -1 || window.location.href.indexOf('ccrz__CCForgotPassword') > -1){
                $('.contentBody.cc_content_body').addClass('container');
                if(CCRZ.changePasswordView){
                    CCRZ.footerView = new CCRZ.views.footerView();
                } else {
                    CCRZ.footerView = new CCRZ.views.footerView();
                }
            }
            if(CCRZ.changePasswordView){
                CCRZ.changePasswordView.viewName = 'changePasswordView';
                document.title = 'Change Password';
                CCRZ.pubSub.once("view:changePasswordView:refresh", function(cpView) {
                  //  $('.changePasswordContainer').addClass('container customBodyContainer');
                    cpView.events['click .submit'] = 'resetPassword';
                    cpView.resetPassword = function (event) {
                        var rfqForm = $("#resetForm").serializeObject();
                        var newPassword = rfqForm.NewPassword;
                        var confirmPassword = rfqForm.ConfirmPassword;
                        if ( newPassword.length < 8) {
                            showError('Password should be minimum of 8 characters');
                        } else if (newPassword != confirmPassword) {
                            showError('Password does not match');
                        } else {
                            resetPasswordfun(cpView);
                        }

                    };
                    cpView.delegateEvents();
                    
                    function showError(errorMsg) {
                        // $(".error-msg").html(errorMsg);
                        // $(".message_container").show();
                        $('.message_container').html('<div class="alert alert-danger">'+errorMsg+'</div>').show();
                        setTimeout(function () {
                            $('.message_container').hide();
                        }, 5000);
                    
                    };

                    function resetPasswordfun(cpView) {
                        var form = $("#resetForm").serializeObject();
                        var view = this;
                        cpView.invoke(
                            "resetPassword",
                            {storefront:CCRZ.pagevars.storefrontName,portalUserId:CCRZ.pagevars.portalUserId},
                            form.NewPassword,
                            form.ConfirmPassword,
                            function(response){
                                if(response.success){
                                    window.location.href = CCRZ.pagevars.sitePrefix+'/apex/ccrz__HomePage?cartID=null&store=CHVACB2BSTORE';
                                }else{
                                    $.each(response.messages,function(){
                                    var message = this.message;
                                    if(this.labelId){
                                        message = CCRZ.pagevars.pageLabels[this.labelId];
                                    }
                                    showError(message);
                                    });
                                }
                            }
                        );
                    };
                    util.hideLoader();
                });
            }
            if(window.location.href.indexOf('ccrz__CCSiteLogin') > -1) {
                CCRZ.pubSub.once('view:loginView:refresh', function(loginView){
                        $('.contentBody.cc_content_body').addClass('container');
                        CCRZ.footerView = new CCRZ.views.footerView();
                        CCRZ.hideLoader();
                        loginView.gotoForgotPassword= function(event) {
                            document.location = CCRZ.pagevars.sitePrefix+"/ccrz__CCPage?pageKey=forgotPassword" + getCSRQueryString();
                        }
                        loginView.delegateEvents();
                });
            } else if(window.location.href.indexOf('ccrz__CCSiteRegister') > -1) {
                CCRZ.pubSub.once('view:newCustomerView:refresh', function(){
                        $('.contentBody.cc_content_body').addClass('container');
                        CCRZ.footerView = new CCRZ.views.footerView();
                        CCRZ.hideLoader();
                });
            } else if(window.location.href.indexOf('ccrz__ProductList') > -1){
                CCRZ.pubSub.once("view:productItemsView:refresh", function(){
                        CCRZ.footerView = new CCRZ.views.footerView();
                });
            } else if(window.location.href.indexOf('ccrz__HomePage') > -1) {
                let isRefreshHome = false;
                CCRZ.pubSub.on('view:spotlightView:refresh', function(){
                    if(!isRefreshHome){
                        CCRZ.footerView = new CCRZ.views.footerView();
                        isRefreshHome = true;
                    }
                });
            } else if(window.location.href.indexOf('ccrz__Cart') > -1) {
                let isRefreshCart = false;
                CCRZ.pubSub.on('view:CartDetailView:refresh', function(){
                    if(!isRefreshCart){
                        CCRZ.footerView = new CCRZ.views.footerView();
                        isRefreshCart = true;
                    }
                });
            } else if(window.location.href.indexOf('ccrz__MyAccount') > -1) {
                let isRefreshMyAccount = false;
                CCRZ.pubSub.on('view:myaccountView:refresh', function(){
                    if(!isRefreshMyAccount){
                        CCRZ.footerView = new CCRZ.views.footerView();
                        isRefreshMyAccount = true;
                    }
                });
            } else if(window.location.href.indexOf('ccrz__CheckoutNew') > -1) {
                let isRefreshCheckout = false;
                CCRZ.pubSub.on('view:cartCheckoutView:refresh', function(){
                    if(!isRefreshCheckout){
                        CCRZ.footerView = new CCRZ.views.footerView();
                        isRefreshCheckout = true;
                    }
                });
            } else if(window.location.href.indexOf('ccrz__StoredPaymentDetail') > -1) {
                let isRefreshStoredPaymentDetail = false;
                $('.contentBody.cc_content_body').addClass('container');
                $('.paymentContainer').addClass('container customBodyContainer mb-3');
                CCRZ.footerView = new CCRZ.views.footerView();
            } else if(window.location.href.indexOf('ccrz__InvoiceDetail') > -1) {
                let isRefreshInvoiceDetail = false;
                CCRZ.pubSub.on('view:InvoiceDetailView:refresh', function(){
                    if(!isRefreshInvoiceDetail){
                        $('.invoiceContainer').addClass('container');
                        CCRZ.footerView = new CCRZ.views.footerView();
                        isRefreshInvoiceDetail = true;
                    }
                });
            } else if(window.location.href.indexOf('ccrz__OrderView') > -1) {
                let isRefreshOrderDetail = false;
                CCRZ.pubSub.on('view:OrderDetailView:refresh', function(orderDetail){
                    if(!isRefreshOrderDetail){
                        CCRZ.footerView = new CCRZ.views.footerView();
                        isRefreshOrderDetail = true;
                        orderDetail.postRender = function() {
                            var v = this;
                            if (CCRZ.ga && CCRZ.pagevars.currentPageName.match(/OrderConfirmation$/gi)) {
                             CCRZ.ga.sendTransaction( _.extend({'source':'orderdetail'}, CCRZ.pagevars), v.model);
                            }
                            $('.orderContainer').addClass('container');
                        }
                        window.setTimeout(function(){
                            orderDetail.render();
                            CCRZ.hideLoader();
                        }, 2000);
                    }
                });
            }  else if(window.location.href.indexOf('ccrz__InvoicePayment') > -1) {
                let isRefresh = false;
                CCRZ.pubSub.on('view:InvoicePaymentView:refresh', function(){
                    if(!isRefresh){
                        $('.invoicePaymentContainer').addClass('container');
                        CCRZ.footerView = new CCRZ.views.footerView();
                        isRefresh = true;
                        CCRZ.hideLoader();
                    }
                });
            } else if(window.location.href.indexOf('pageKey=mySubscriptions') > -1){
                CCRZ.footerView = new CCRZ.views.footerView();
            } else {
                CCRZ.footerView = new CCRZ.views.footerView();
                CCRZ.hideLoader();
            }
        } 
    }
});

