d("checkoutPageView",['util','checkoutModel'], function(UTIL, checkoutModel) {

    return {
        extendCheckoutPageView: function() {
            var autocomplete;
            CCRZ.remoteActions = _.extend(CCRZ.remoteActions||{});
            
            CCRZ.remoteActions.checkoutPageRemoting =  _.extend(CCRZ.RemoteInvocation,{ 
                className : 'CHVACB2B_checkoutPageCX', 
                updateAutoRenew : function(reqData, callback){ 
                    this.invokeCtx('updateAutoRenew',
                        reqData,
                        function(resp, evt){ 
                            if(callback){
                                callback(resp,evt);
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        } 
                    );
                }
            });
            let isRefreshPayment = false, coModel = new checkoutModel();
            CCRZ.pubSub.on('view:PaymentProcessorView:refresh',function(paymentView){
                if(!isRefreshPayment){
                    isRefreshPayment = true;
                    setTimeout(function(){
                        paymentView.render();
                    }, 1000);
                }
            });
            let isRendered = false;
            CCRZ.pubSub.on('view:cartCheckoutView:refresh',function(checkoutView){
                validateOSCAddress(checkoutView);
                checkoutView.events['click .processBack'] = 'handleBack';
                checkoutView.handleBack = function(event){
                    $('#sidebarBackdrop').removeClass('hide');
                    nextIndex = this.currStep - 1;
                    if (!this.subViewArray[nextIndex] && nextIndex >= 0){
                    nextIndex--;
                    }
                    if(nextIndex >= 0){
                        window.location.href = CCRZ.pagevars.currentPageURL;
                    }else{
                        cartDetails();
                    }
                };
                checkoutView.loadDesktopView = function(){
                    let _this = this;
                    if (_this.subView)
                    _this.subView.setElement(this.$el);
                    else {
                        _this.subView = _this.subViewArray[0];
                        _this.subView.setElement(_this.$el);
                    }
                    _this.subView.render();
                    _this.updateNav();
                    if(_this.subView.viewName == 'PaymentView'){
                        UTIL.hideLoader();
                    }
                };
                checkoutView.delegateEvents();
                if(CCRZ.cartCheckoutView.subViewArray && CCRZ.cartCheckoutView.subViewArray.length > 0){
                    let isShippingRemoved = false, isUserInfoRemoved = false;
                    let viewLength =  CCRZ.cartCheckoutView.subViewArray.length, newSubArray = [];
                    for(let i = 0; i <viewLength; i++) {
                        let currentSubView = CCRZ.cartCheckoutView.subViewArray[i];
                        if (i === 1 && typeof currentSubView == 'undefined') {
                            isShippingRemoved = true;
                        }
                        if (i === 0 && typeof currentSubView == 'undefined') {
                            isUserInfoRemoved = true;
                        }
                        if (typeof currentSubView != 'undefined')
                        {
                            if (typeof currentSubView.title != 'undefined' &&
                                (currentSubView.title === 'Shipping' || currentSubView.title === 'User Information')) {
                                CCRZ.cartCheckoutView.removeView(i);
                            } else if (typeof currentSubView.title != 'undefined' && i === 2) {
                                CCRZ.cartCheckoutView.subView = CCRZ.cartCheckoutView.subViewArray[i].view;
                                newSubArray.push(CCRZ.cartCheckoutView.subViewArray[i]);
                            } else {
                                newSubArray.push(CCRZ.cartCheckoutView.subViewArray[i]);
                            }
                        }
                    }
                    if(!isShippingRemoved && !isUserInfoRemoved && !isRendered){
                        isRendered = true;
                        checkoutView.subViewArray = newSubArray;
                        checkoutView.navView.model.views = newSubArray;
                        checkoutView.lastIdx = newSubArray.length - 1;
                        checkoutView.navView.render();
                        UTIL.calculateSubscriptionPrices(checkoutView.model.attributes.cartItems, checkoutView, 'review');
                        checkoutView.render();
                    }
                }
            });
            CCRZ.pubSub.once('view:OrderReviewView:refresh',function(orderReview){
                
                CCRZ.cartCheckoutModel.set('isEditModal', false);
                orderReview.events['click .processReviewCustom'] = 'processCustomReview';
                orderReview.events['change #autorenew'] = 'handleAutoRenewChange';
                orderReview.events['click .checkoutEditAddress'] = 'handleEditModal';
                orderReview.events['change #addressModal .countryListing'] = 'handleCountryChange';
                orderReview.events['click #addressModal .submitAddress'] = 'handleSaveAddress';
                orderReview.events['input #poNumberAccount'] = 'handleUpdatePO';
                orderReview.events['change #selectShipping'] = 'handleShippingSelection';
                orderReview.handleUpdatePO = function(event){
                    let val = event.target.value;
                    CCRZ.cartCheckoutModel.attributes['accountR']['CHVACPONumber'] = val;
                };
                orderReview.handleShippingSelection = function(event){
                    CCRZ.showLoader();
                    let val = event.target.value, shippingMethods = CCRZ.cartCheckoutModel.get('shippingOptions'), ShippingMethod = '',ShippingCharge = '';

                    shippingMethods.forEach(function(item){
                        item.checked = item.Id == val?true:false;
                        if(item.Id == val){
                            CCRZ.cartCheckoutModel.set('shippingCharge', item.ccrz__ShippingRate__c);
                            CCRZ.cartCheckoutModel.set('totalAmount', CCRZ.cartCheckoutModel.get('shippingCharge') + CCRZ.cartCheckoutModel.get('taxSubTotalAmount'));
                            ShippingCharge = item.ccrz__ShippingRate__c;
                            ShippingMethod = item.Name;
                        }
                    });

                    let salesemailAdd = $('#salesemail').val(); 
                    debugger;
                    //console.log(CCRZ.cartCheckoutModel.attributes['accountR']['CHVACSalesOwnerEmail']);
                    let reqJSON = {
                        'account' : CCRZ.cartCheckoutModel.get('account'),
                        'poNumber' : '',
                        'salesemail' : '',
                        'shippingMethod': ShippingMethod+'',
                        'shippingNote': $('#shippingNotes').val(),
                        'shipAmount' : ShippingCharge+''
                    };
                    coModel.updateDetails(JSON.stringify(reqJSON), function(res, event){
                        if(res && res.success){
                            orderReview.calculateTax();
                        } else {
                            // Error Handling  
                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", 'Error calculating shipping tax'));
                            debugger;
                        }
                    });    

                    CCRZ.cartCheckoutModel.set('shippingOptions', shippingMethods);
                    this.render();
                };
                orderReview.handleSaveAddress = function(){debugger;
                    if($("#addressForm").valid()){
                        CCRZ.showLoader();
                        let _this = this, addrForm = form2js('addressForm', '.', false, function(node) {}, false, true)
                        , reqJSON = addrForm.Address;
                        reqJSON['type'] = CCRZ.cartCheckoutModel.get('addressType');
                        reqJSON['account'] = CCRZ.cartCheckoutModel.get('account');
                        reqJSON['billTo'] = CCRZ.cartCheckoutModel.get('billTo');
                        reqJSON['shipTo'] = CCRZ.cartCheckoutModel.get('shipTo');
                        coModel.saveAddress(JSON.stringify(reqJSON), function(res, event){
                            if(res && res.success){
                                let address = {};
                                if(reqJSON.type == 'shipping'){
                                    address = CCRZ.cartCheckoutModel.get('shippingAddress');
                                } else {
                                    address = CCRZ.cartCheckoutModel.get('billingAddress');
                                }
                                address.address1 = reqJSON.addressLine1;
                                address.address2 = reqJSON.addressLine2;
                                address.city = reqJSON.city;
                                address.country = reqJSON.countryCode;
                                address.countryCode = reqJSON.countryCode;
                                address.state = reqJSON.stateCode;
                                address.stateCode = reqJSON.stateCode;
                                address.postalCode = reqJSON.postalCode;
                                CCRZ.cartCheckoutModel.set((reqJSON.type == 'shipping')?'shippingAddress':'billingAddress', address);
                                var cartjson = JSON.stringify(CCRZ.cartCheckoutModel.get('shippingAddress'));
                                _this.render();
                            } else {
                                // Error Handling
                            }
                            orderReview.calculateTax();
                            $('body').removeClass('modal-open');
                        });
                    } else {
                        // Error out only
                        // If the account is not an International account and the logged in person is not a CSR
                        console.log(UTIL.isInternationalAccount());
                        if(!UTIL.isInternationalAccount()) {
                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "messagingSection-addressModal-Error", CCRZ.processPageLabelMap('CHVAC_all_errorAllRequired').toString()));
                            $('#addressModal .modal-body').animate({ scrollTop: 0 }, 'slow');
                        }
                    }
                };
                orderReview.validateAddressForm = function(){
                    $("#addressForm").validate({
                        invalidHandler: function(event, validator) {
                         CCRZ.handleValidationErrors(event, validator, 'main-messagingSection-Error', false);
                        },
                        rules: {
                        'Address.addressLine1': {
                          required: true
                         },
                         'Address.city': {
                          required: true
                         },
                         'Address.postalCode': {
                          required: true,
                          maxlength: 10
                         }
                        },
                        messages: {
                         'Address.addressLine1': {
                          required: CCRZ.processPageLabelMap('CHVAC_all_errorAddressLine1').toString()
                         },
                         'Address.city': {
                          required: CCRZ.processPageLabelMap('CHVAC_all_errorCity').toString()
                         },
                         'Address.postalCode': {
                          required: CCRZ.processPageLabelMap('CHVAC_all_errorPostalCode').toString(),
                          maxlength: CCRZ.processPageLabelMap('CHVAC_all_errorPostalCodeMax').toString()
                         }
                        },
                        errorPlacement: function(error, element) { }
                    });
                },
                orderReview.handleCountryChange = function(event){
                    CCRZ.cartCheckoutModel.attributes.selectedAddress.country = event.target.value;
                    orderReview.addressStateView.render('state', _.isUndefined(CCRZ.cartCheckoutModel.attributes.selectedAddress.state)?'GA':CCRZ.cartCheckoutModel.attributes.selectedAddress.state
                    , 'wide form-control', 
                    CCRZ.geoCodes.filterStates(event.target.value).toJSON(), '', '#addressForm .stateSection');
                };
                orderReview.handleEditModal = function(event){
                    debugger;
                    let _this = this, type = event.target.dataset.type;
                    let isInternationalAccountFlag = (UTIL.isCSRFlow() && UTIL.isInternationalAccount()) ? true : false;

                    CCRZ.cartCheckoutModel.set('isEditModal', true);
                    CCRZ.cartCheckoutModel.set('selectedAddress', type == 'billing'?CCRZ.cartCheckoutModel.get('billingAddress'):CCRZ.cartCheckoutModel.get('shippingAddress'));
                    CCRZ.cartCheckoutModel.set('addressType', type);
                    if(!isInternationalAccountFlag && type != 'billing' && CCRZ.cartCheckoutModel.attributes.shippingAddress.country == ''){
                        if(CCRZ.cartCheckoutModel.attributes.billingAddress.country == 'CA'){
                            CCRZ.cartCheckoutModel.attributes.shippingAddress.country = 'CA';
                            CCRZ.cartCheckoutModel.attributes.shippingAddress.state = 'AB';
                        }else{
                            CCRZ.cartCheckoutModel.attributes.shippingAddress.country = 'US';
                            CCRZ.cartCheckoutModel.attributes.shippingAddress.state = 'AL';
                        }
                    }
                    _this.render();
                };
                orderReview.processCustomReview = function(event){
                    let isSubscTerms = $('.cc_subsc_terms').is(":checked")
                    , isTcTerms = $('.cc_tc_terms').is(":checked");
                    //errorHandleCheckbox(isSubscTerms, '.cc_subsc_terms');
                    errorHandleCheckbox(isTcTerms, '.cc_tc_terms');
                    let emptyShippingAddress = checkEmptyAddress();

                    // Error out only
                    // If the account is not an International account and the logged in person is not a CSR
                    console.log(UTIL.isInternationalAccount());
                    console.log(UTIL.isCSRFlow());
                    let isPOAvailable = (($('#poNumberAccount').val().length > 0 && UTIL.isCSRFlow()) || !UTIL.isCSRFlow())?true:false;
                    // if(!isPOAvailable){
                    //     CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", CCRZ.processPageLabelMap('CHVAC_CO_errorPO').toString()));
                    //     return;
                    // }

                    // BillTo and ShipTo address should have same country
                    let billToCountry = CCRZ.cartCheckoutModel.attributes.billingAddress.country;
                    let shipToCountry = CCRZ.cartCheckoutModel.attributes.shippingAddress.country;

                    let billCountryAvailable = !_.isUndefined(billToCountry) && billToCountry != '' ? true : false;
                    
                    if (billCountryAvailable && billToCountry != shipToCountry) {
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", CCRZ.processPageLabelMap('CHVAC_CO_errorAddress').toString())); 
                        return;
                    }

                    let isInternationalAccountFlag = (isTcTerms && UTIL.isCSRFlow() && UTIL.isInternationalAccount()) ? true : false; 
                    let taxError = CCRZ.cartCheckoutModel.get('taxError');
                    if(taxError){
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", CCRZ.processPageLabelMap('CHVAC_CO_taxError').toString())); 
                        return;                        
                    }
                    if((isInternationalAccountFlag) || (!emptyShippingAddress && (isTcTerms))){
                        CCRZ.showLoader();
                        debugger;
                        let shippingMethods = CCRZ.cartCheckoutModel.get('shippingOptions'), 
                        isShipping = CCRZ.cartCheckoutModel.get('isShipping'), shippingMethod = '';
                        if(isShipping && !_.isUndefined(shippingMethods) && shippingMethods.length > 0){
                            shippingMethod = shippingMethods.filter(function(method){
                                return method.checked;
                            });
                        }

                        if (isInternationalAccountFlag && isShipping) {
                            if(isShipping && !_.isUndefined(shippingMethods) && shippingMethods.length > 0){
                                shippingMethod = shippingMethods.filter(function(method){
                                    return method.ccrz__ShippingRate__c == 0;
                                });
                            }
                        }
                        var salesemailAdd = $('#salesemail').val(); 
                        debugger;
                        //console.log(CCRZ.cartCheckoutModel.attributes['accountR']['CHVACSalesOwnerEmail']);
                        let shippingCost = isShipping?(shippingMethod.length > 0?shippingMethod[0].ccrz__ShippingRate__c:0):0;
                        let reqJSON = {
                            'account' : CCRZ.cartCheckoutModel.get('account'),
                            'poNumber' : CCRZ.cartCheckoutModel.attributes['accountR']['CHVACPONumber'],
                            'salesemail' : salesemailAdd,
                            'shippingMethod': isShipping?(shippingMethod.length > 0)?shippingMethod[0].Name:'':'',
                            'shippingNote': isShipping?$('#shippingNotes').val():'',
                            'shipAmount' : shippingCost + ''
                        };
                        coModel.updateDetails(JSON.stringify(reqJSON), function(res, event){
                            if(res && res.success){
                                if((CCRZ.cartCheckoutModel.get('totalAmount') + shippingCost) == 0){
                                    coModel.placeZeroCheckout(function(resCH, event){
                                        if(resCH && resCH.success){
                                            orderDetails(resCH.data);
                                        } else {
                                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", resCH.data));
                                        }
                                    });
                                } else {
                                    CCRZ.cartCheckoutView.slideRight();
                                }
                            } else {
                                // Error Handling
                            }
                        });          
                    } else {
                        
                        console.log('error');
                        let errorMessage = CCRZ.processPageLabelMap('CHVAC_CO_errorTC').toString();
                        if(UTIL.isCSRFlow() && isTcTerms){
                            errorMessage = CCRZ.processPageLabelMap('CHVAC_CO_errorPO').toString()
                        }
                        if(emptyShippingAddress){
                            errorMessage = CCRZ.processPageLabelMap('CHVAC_CO_errorValidShip').toString();
                        }
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", errorMessage));
                    
                    }
                }
                orderReview.renderDesktop = function() {
                    let isInternationalAccountFlag = (UTIL.isCSRFlow() && UTIL.isInternationalAccount()) ? true : false;

                    let countryList = CCRZ.cartCheckoutModel.get('countryList'), cartItems = CCRZ.cartCheckoutModel.get('cartItems')
                    , filterList = !isInternationalAccountFlag ? countryList.filter(function(country){
                        return country.value == 'US' || country.value == 'CA';
                    }) : countryList, isShipping = false;

                    
                    CCRZ.cartCheckoutModel.set('countryList', filterList);
                    CCRZ.cartCheckoutModel.attributes.billingAddress.countryList = filterList;
                    CCRZ.cartCheckoutModel.attributes.shippingAddress.countryList = filterList;
                    if(!isInternationalAccountFlag){
                        cartItems.forEach(function(cartItem){
                            if(!_.isUndefined(cartItem.mockProduct.shippingWeight)){
                                isShipping = true;
                            }
                        });
                        CCRZ.cartCheckoutModel.set('isShipping', isShipping);
                        if(!isShipping){
                            CCRZ.cartCheckoutModel.set('shippingCharge', 0);
                            CCRZ.cartCheckoutModel.set('totalAmount', CCRZ.cartCheckoutModel.get('taxSubTotalAmount'));
                        }
                    }
                    this.renderView(this.templateDesktop);
                    this.validateAddressForm();
                    this.cartView.renderDesktop(this.$el.find(".reviewCartSection"));
                },
                orderReview.handleAutoRenewChange = function(event){
                    let autoRenew = event.target.checked;
                    let reqData = { 'cartEncId' : CCRZ.pagevars.currentCartID, 'autoRenew' : autoRenew };
                    CCRZ.cartCheckoutModel.set('DCMAutoRenew', autoRenew);
                    $('#sidebarBackdrop').removeClass('hide');
                    CCRZ.remoteActions.checkoutPageRemoting.className = 'CHVACB2B_checkoutPageCX';
                    CCRZ.remoteActions.checkoutPageRemoting.updateAutoRenew(JSON.stringify(reqData),function(res,evt){
                        if(res && res.success){
                            // Success Auto Renew
                        } else {
                            CCRZ.cartCheckoutModel.set('DCMAutoRenew', !autoRenew);
                            // Error on controller
                            console.log('ERROR: ' + res.data);
                        }
                        orderReview.render();
                        $('#sidebarBackdrop').addClass('hide');
                    }); 
                };
                orderReview.calculateTax = function(){
                    debugger;
                    
                    /*if(!CCRZ.cartCheckoutModel.attributes.shippingAddress.stateCode){
                        CCRZ.cartCheckoutModel.attributes.shippingAddress.stateCode = CCRZ.cartCheckoutModel.attributes.shippingAddress.state;
                    }
                    if(!CCRZ.cartCheckoutModel.attributes.shippingAddress.countryCode){
                        CCRZ.cartCheckoutModel.attributes.shippingAddress.countryCode = CCRZ.cartCheckoutModel.attributes.shippingAddress.country;
                    }*/

                    // Check if the logged in is a CSR and the customer is an Internatinal account
                    //let isInternationalAccountFlag = (UTIL.isCSRFlow() && UTIL.isInternationalAccount()) ? true : false;
                    
                    // Do not calculate Tax if tax exempt
                    if (!_.isUndefined(CCRZ.cartCheckoutModel.get('CHVACIsTaxExempt')) && !CCRZ.cartCheckoutModel.get('CHVACIsTaxExempt')) {
                        CCRZ.showLoader();
                        let shippingAddr = CCRZ.cartCheckoutModel.get('shippingAddress');
                        shippingAddr['countryList'] = null;
                        let _this = this, cartjson = JSON.stringify(shippingAddr);
                        _this.invokeContainerLoadingCtx($('.deskLayout'), 'fetchTax', cartjson, CCRZ.cartCheckoutModel.get('sfid'), function(response) {
                            if (response && response.success && !_.isUndefined(response.data)) {
                                CCRZ.cartCheckoutModel.set('tax', response.data);
                                CCRZ.cartCheckoutModel.set('taxSubTotalAmount', CCRZ.cartCheckoutModel.get('subtotalAmount') + CCRZ.cartCheckoutModel.get('tax'));
                                CCRZ.cartCheckoutModel.set('totalAmount', CCRZ.cartCheckoutModel.get('shippingCharge') + CCRZ.cartCheckoutModel.get('taxSubTotalAmount'));
                                CCRZ.cartCheckoutModel.set('taxError', false);
                            } else {debugger;
                                CCRZ.cartCheckoutModel.set('taxError', true);
                                CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", CCRZ.processPageLabelMap('CHVAC_TaxCalculation_ErrorMessage').toString()));
                                CCRZ.hideLoader();
                                return;
                                /*if (response.messages && response.messages.length > 0) {
                                    CCRZ.cartCheckoutModel.set('messages', response.messages);
                                }*/
                            }
                            orderReview.render();
                            CCRZ.hideLoader();
                        }, {
                            buffer: false
                        });
                    } else {
                        orderReview.render();
                        CCRZ.hideLoader();
                    }
                    
                },
                orderReview.postRender = function(){
                    let _this = this;
                    if(CCRZ.cartCheckoutModel.get('isEditModal')){
                        debugger;
                        orderReview.addressStateView = new CCRZ.views.StateView();
                        let address = CCRZ.cartCheckoutModel.get('selectedAddress');
                        orderReview.addressStateView.render('state', _.isUndefined(address.state)?'GA':address.state, 'wide form-control'
                        , CCRZ.geoCodes.filterStates(address.country).toJSON(), '', '#addressForm .stateSection');
                        $('#addressModal').modal({backdrop: true, show: true}); 
                        CCRZ.cartCheckoutModel.set('isEditModal', false);

                        const options = {
                            componentRestrictions: { country: ["us","ca"] },
                            fields: ["address_components", "geometry", "icon", "name"],
                            strictBounds: false,
                            types: ["geocode"],
                          };
                        const input = document.getElementById("addressLine1");
                        autocomplete = new google.maps.places.Autocomplete(input, options);

                        autocomplete.addListener('place_changed',onPlaceChanged);
                    } else {
                        $('.modal-backdrop').remove();
                    }
                };
                orderReview.delegateEvents();
                
                let isInternationalAccountFlag = (UTIL.isCSRFlow() && UTIL.isInternationalAccount()) ? true : false
                , isShipping = false,cartItems = CCRZ.cartCheckoutModel.get('cartItems'), totalWeight = 0;
                
                if(!isInternationalAccountFlag){
                    cartItems.forEach(function(cartItem){
                        if(!_.isUndefined(cartItem.mockProduct.shippingWeight)){
                            isShipping = true;
                            totalWeight += cartItem.mockProduct.shippingWeight * cartItem.quantity;
                        }
                    });
                    coModel.getShippingRates(JSON.stringify({'shipTo': CCRZ.cartCheckoutModel.attributes.shipTo, 'totalWeight' : totalWeight + ''}), function(res, event){
                        if(res && res.success){
                            if(res.data && res.data.length > 0){  
                                res.data.forEach(function(shipRate, index){
                                    if(index == 0){
                                        shipRate['checked'] = true;
                                        if(isShipping){
                                            let salesemailAdd = $('#salesemail').val(); 
                                            debugger;
                                            //console.log(CCRZ.cartCheckoutModel.attributes['accountR']['CHVACSalesOwnerEmail']);
                                            updateCartDetails(shipRate, '','','', orderReview, true);
                                        }else{
                                            updateCartDetails(null, '','','', orderReview, true);
                                        }
                                    } else {
                                        shipRate['checked'] = false;
                                    }
                                });
                                CCRZ.cartCheckoutModel.set('shippingOptions', res.data);
                            } else {
                                updateCartDetails(null, '','','', orderReview, true);
                            }
                        } else {
                            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", 'Error calculating shipping amount'));
                            CCRZ.cartCheckoutModel.set('taxError', true);
                            CCRZ.hideLoader();
                            return;
                            // Error Handling
                        }
                        
                    });
                    if(!isShipping){
                        updateCartDetails(null, '','','', orderReview, true);
                    }
                } else {
                    updateCartDetails(null, '','','', orderReview, false);
                }
            });

            function errorHandleCheckbox(isCheck, checkElm){
                if(!isCheck){
                    $('.alertCheckbox').removeClass('hide');
                } else {
                    $('.alertCheckbox').addClass('hide');
                }
            }

            function updateCartDetails(shipRate, shippingNote, salesemail, poNumber, orderReview, isCalculateTax){
                let reqJSON = {
                    'account' : CCRZ.cartCheckoutModel.get('account'),
                    'poNumber' : poNumber,
                    'salesemail' : salesemail,
                    'shippingMethod': shipRate == null?'':shipRate.Name+'',
                    'shippingNote': shippingNote,
                    'shipAmount' : shipRate == null?'0':shipRate.ccrz__ShippingRate__c+''
                };
                CCRZ.cartCheckoutModel.set('shippingCharge', shipRate == null?0:shipRate.ccrz__ShippingRate__c);
                CCRZ.cartCheckoutModel.set('totalAmount', CCRZ.cartCheckoutModel.get('shippingCharge') + CCRZ.cartCheckoutModel.get('taxSubTotalAmount'));
                coModel.updateDetails(JSON.stringify(reqJSON), function(res, event){
                    if(res && res.success){
                        if(isCalculateTax){
                            orderReview.calculateTax();
                        } else {
                            orderReview.render();
                            CCRZ.hideLoader();
                        }
                    } else {
                        // Error Handling  
                        CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('ERROR', "checkout-messagingSection-Error", 'Error calculating shipping tax'));
                        CCRZ.cartCheckoutModel.set('taxError', true);
                    }
                });  
            }
            function onPlaceChanged(){
                debugger;
                var place = autocomplete.getPlace();
                let address1 = "";
                let postcode = "";
                let city = '';
                let country = '';
                let stateProvince = '';
                // Get each component of the address from the place details,
                // and then fill-in the corresponding field on the form.
                // place.address_components are google.maps.GeocoderAddressComponent objects
                // which are documented at http://goo.gle/3l5i5Mr
                for (const component of place.address_components) {
                  const componentType = component.types[0];
              
                  switch (componentType) {
                    case "street_number": {
                      address1 = `${component.long_name} ${address1}`;
                      break;
                    }
              
                    case "route": {
                      address1 += component.short_name;
                      break;
                    }
              
                    case "postal_code": {
                      postcode = `${component.long_name}${postcode}`;
                      break;
                    }
              
                    case "postal_code_suffix": {
                      postcode = `${postcode}-${component.long_name}`;
                      break;
                    }
                    case "locality":
                        city = component.long_name;
                      break;
                    case "administrative_area_level_1": {
                        stateProvince = component.short_name;
                        break;
                    }
                    case "country":
                        country = component.short_name;
                      break;
                  }
                  document.getElementById("addressLine1").value = address1;
                  let statesCode = document.getElementsByName("Address.stateCode");
                  if(statesCode.length > 0){
                    statesCode[0].value = stateProvince;
                  }
                 // document.getElementById("country")
                  //document.getElementById("city")
                  document.getElementById("city").value = city;
                  document.getElementById("postalCode").value = postcode;
                }
            }
            function validateOSCAddress(){
                let stateList = CCRZ.geoCodes.stateList.models;
                let countryList = CCRZ.geoCodes.countryList.models;
                let stateValid = false;
                let countryValid = false;
                let isInternationalAccountFlag = (UTIL.isCSRFlow() && UTIL.isInternationalAccount()) ? true : false;
                debugger;
                
                //CCRZ.cartCheckoutModel.attributes.shippingAddress;
                stateList.forEach(function(state){
                    if(state.attributes.value == CCRZ.cartCheckoutModel.attributes.shippingAddress.state){
                        stateValid = true;
                    }
                });
                countryList.forEach(function(country){
                    if(country.attributes.value == CCRZ.cartCheckoutModel.attributes.shippingAddress.country){
                        countryValid = true;
                    }
                });

                if((!stateValid || !countryValid ) && !isInternationalAccountFlag) {
                    CCRZ.cartCheckoutModel.attributes.shippingAddress.country = '';
                    CCRZ.cartCheckoutModel.attributes.shippingAddress.state = '';
                }
                /*if(!stateValid){
                    CCRZ.cartCheckoutModel.attributes.shippingAddress.state = '';
                }
                if(!countryValid){
                    CCRZ.cartCheckoutModel.attributes.shippingAddress.country = '';
                    CCRZ.cartCheckoutModel.attributes.shippingAddress.state = '';
                }*/
            }
            function checkEmptyAddress(){debugger;
                if(CCRZ.cartCheckoutModel.attributes.shippingAddress.country && CCRZ.cartCheckoutModel.attributes.shippingAddress.address1
                && CCRZ.cartCheckoutModel.attributes.shippingAddress.state && CCRZ.cartCheckoutModel.attributes.shippingAddress.city
                && CCRZ.cartCheckoutModel.attributes.shippingAddress.postalCode && CCRZ.cartCheckoutModel.attributes.billingAddress.country 
                && CCRZ.cartCheckoutModel.attributes.billingAddress.address1 && CCRZ.cartCheckoutModel.attributes.billingAddress.state 
                && CCRZ.cartCheckoutModel.attributes.billingAddress.city && CCRZ.cartCheckoutModel.attributes.billingAddress.postalCode){
                    return false;
                }else{
                    return true;
                }
            }
            //
            let isStorePay = false;
            CCRZ.pubSub.on('view:PaymentView:refresh',function(view){
                debugger;
                console.log('hi::11');
                setTimeout(function(){
                    let paymentView = view;
                    let storedPayments = paymentView.model.get('storedPayments');
                    let resdata = {
                        stored: storedPayments
                    };
                    //paymentView.listenTo(paymentView.model,'change:storedPayments', paymentView.render);
                    var remoteCall = _.extend(CCRZ.RemoteInvocation,{className:'CHVACB2B_checkoutPageCX'});
                    remoteCall.invokeCtx(
                        'getUpdatedStoredPayments',JSON.stringify(resdata),
                        function(res, event) {
                            console.log('hi::1');
                            debugger;
                            if(!$(".cc_stored_payments_container #storedPay").is(":visible") && !storedPayments === res.data.storedPayments){
                                console.log('hi::2');
                                isStorePay = false;
                            }
                            if(res && res.data && !isStorePay){  
                                console.log('hi::3');
                                    isStorePay = true;                          
                                    paymentView.model.set('storedPayments',res.data.storedpayments);
                                    paymentView.paymentModel.attributes.storedPay = res.data.storedpayments
                                    paymentView.render();
                            }            
                        }, 
                        { 
                            buffer:false, 
                            nmsp : false 
                        }
                    ); 
                },1000);
            });
        } 
        
    }
});

