d("paymentPODView",['ccrz', 'util', 'paymentPODModel'], function(CCRZ, UTIL, paymentPODModel) {

    return {
        extendPaymentPODView: function() {
            let stripekey = '';
            let stripe = '';
            let card = '';
            let paymentModel = new paymentPODModel(), countryList = [], stateList =[], stateCode = '', modalData = {};
            function checkStoredPaymentScenario(){
                return CCRZ.pagevars.currentPageName.toLowerCase() == 'ccrz__storedpaymentdetail';
            }
            function getStateList(sList, countryCode){
                let currentStateList = sList.filter(function(state){
                    return state.countryCode == countryCode
                });
                return currentStateList;
            }
            CCRZ.views.customStateView = CCRZ.CloudCrazeView.extend({
                el: CCRZ.uiProperties.customStateView.desktop.selector,
                viewName: "customStateView",
                template: CCRZ.util.template(CCRZ.uiProperties.customStateView.desktop.tmpl),
                init: function(){
                    let v = this;
                    v.render([]);
                },
                render: function(stateList, ele){
                    this.setElement(ele);
                    this.$el.html(this.template({
                        'stateList': stateList,
                        'stateCode': stateCode
                    }));
                },
                events: {
                    'change .billingstate' : 'handleStateChange'
                },
                handleStateChange: function(event){
                    event.preventDefault();
                    return false;
                }
            });
            CCRZ.views.PaymentsPODView = CCRZ.CloudCrazeView.extend({
                viewName: "paymentPODView",
                managedSubView: true,
                templateDesktop: CCRZ.util.template(CCRZ.uiProperties.paymentPODView.desktop.tmpl),
                templatePhone: CCRZ.util.template(CCRZ.uiProperties.paymentPODView.desktop.tmpl),
                init: function(options) {
                    this.selector = options.selector;
                    this.render();
                    this.customStateView = new CCRZ.views.customStateView();
                    CCRZ.pubSub.trigger('action:paymentViewInit', this);
                },
                parentPreRender: function() {
                    //Look for the instantiated iframe
                    //Detach it from the DOM
                    //Re-render the view but dont create the iframe
                    //Re-attach the iframe as appropriate in the rendered view
                },
                renderDesktop: function() {
                    let _this = this;
                    if(checkStoredPaymentScenario()){
                        this.setElement(CCRZ.uiProperties.StoredPaymentsPOView.desktop.selector);
                    }else{
                        this.setElement(this.selector);
                    }
                    if(checkStoredPaymentScenario()){
                        countryList = JSON.parse(sessionStorage.getItem('countryList')), stateList = JSON.parse(sessionStorage.getItem('stateList'));
                        let currentStateList = getStateList(stateList, 'US');
                        this.data = {
                            'countryList': (countryList)?countryList:[],
                            'stateList': (currentStateList)?currentStateList:[],
                            'countryCode': 'US',
                            'classPrefix': ''
                        };
                    } else {
                        this.data = {
                            'countryList': (CCRZ.cartCheckoutModel && CCRZ.cartCheckoutModel.attributes.countryList)?CCRZ.cartCheckoutModel.attributes.countryList:[],
                            'countryCode': ((CCRZ.cartCheckoutModel && CCRZ.cartCheckoutModel.attributes.billingAddress)?'US':'US'),
                            'classPrefix': ''
                        };
                    }
                    this.$el.html(this.templateDesktop(this.data));
                    $('.countryListing').trigger('change');
                    setTimeout(function(){
                        _this.invokeStripeInitiation();
                    }, 1000);
                    
                    //savecard on auto-renewal
                    this.saveCardOnAutoRenew();
                    
                    //hide save cardblock on storepayment
                    this.hideCardBlock();
                },
                renderPhone: function() {
                    let _this = this;
                    if(checkStoredPaymentScenario()){
                        this.setElement(CCRZ.uiProperties.StoredPaymentsPOView.desktop.selector);
                    }else{
                        this.setElement(this.selector);
                    }
                    this.data = {};
                    this.$el.html(this.templatePhone(this.data));
                    
                    setTimeout(function(){
                        _this.invokeStripeInitiation();
                    }, 1000);
                    
                    //savecard on auto-renewal
                    this.saveCardOnAutoRenew();
                    
                    //hide save cardblock on storepayment
                    this.hideCardBlock()
                },
                events : {
                    'click #makePODPayment' : 'handlePODPayment',
                    'change .countryListing' : 'handleChangeCountry'
                },
                handleChangeCountry: function(event){
                    var _this = this;
                    var selectedCountry = $(event.target).val(), currentStateList = [];
                    var billStateStyle = 'wide form-control';
                    if (CCRZ.display.isPhone()) {
                        billStateStyle = 'checkout_wide form-control';
                    }
                    if(checkStoredPaymentScenario()){
                        currentStateList = getStateList(stateList, selectedCountry);
                        stateCode = '';
                    } else {
                        currentStateList = CCRZ.geoCodes.filterStates(selectedCountry).toJSON();
                        stateCode = ((CCRZ.cartCheckoutModel && CCRZ.cartCheckoutModel.attributes.billingAddress && CCRZ.cartCheckoutModel.attributes.billingAddress.state)?CCRZ.cartCheckoutModel.attributes.billingAddress.state:'');
                    }
                    _this.customStateView.render(currentStateList, CCRZ.uiProperties.customStateView.desktop.selector);
                },
                invokeStripeInitiation: function(){
                    let _this = this;
                    _this.model.fetchPublicKey(function(response, event){
                        if(response.success && response.data) {
                            _this.invokeInitialStripe(response.data);
                        } else {

                        }
                    });
                },
                invokeInitialStripe: function(stripePublicKey){
                    // Create a Stripe client.
                    stripekey = stripePublicKey;
                    stripe = Stripe(stripekey);
                    // Create an instance of Elements.
                    var elements = stripe.elements();
                    // Custom styling can be passed to options when creating an Element.
                    // (Note that this demo uses a wider set of styles than the guide below.)
                    var style = {
                        base: {
                            color: '#32325d',
                            lineHeight: '18px',
                            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                            fontSmoothing: 'antialiased',
                            fontSize: '16px',
                            '::placeholder': {
                                color: '#aab7c4'
                            }
                        },
                        invalid: {
                            color: '#fa755a',
                            iconColor: '#fa755a'
                        }
                    };
                    // Create an instance of the card Element.
                    card = elements.create('card', {
                        style: style
                    });
                    // Add an instance of the card Element into the `card-element` <div>.
                    card.mount('#card-element');
                    // Handle real-time validation errors from the card Element.
                    card.addEventListener('change', function(event) {
                        var displayError = document.getElementById('card-errors');
                        if(event.error) {
                            displayError.textContent = event.error.message;
                            return false;
                        } else {
                            displayError.textContent = '';
                        }
                    });
                },
                saveCardOnAutoRenew: function(){
                    if(CCRZ.cartCheckoutModel){        
                        if(CCRZ.cartCheckoutModel.attributes.ALTB2BAutoRenew){
                            var savecardcheckbox = $("#Check");
                            savecardcheckbox.attr("checked",true);
                            savecardcheckbox.attr("disabled", true);
                            savecardcheckbox.attr("title", "Auto-renew orders require us to save your card for future transactions. We don't save details like card no. and cvv/cvc code.");
                        }
                    }
                },
                hideCardBlock: function(){
                    if(checkStoredPaymentScenario()){
                        document.getElementById("savecardblock").remove();
                    }
                },
                handlePODPayment: function(){
                    let _this = this;
                    event.preventDefault();
                    if(UTIL.validateAllFieldTypesById('.inputValBilling input')){
                        $('#sidebarBackdropCustom').removeClass('hide');  
                        var data = _this.getLatestBillingAddress(_this);
                        stripe.createToken(card, data).then(function(result) {
                            //wt here: validate email field START
                            if(result.token) {
                                // Send the token to your server.
                                _this.stripeTokenHandler(result, _this);
                            } else {
                                // Inform the user if there was an error.
                                $.alert({
                                    title: 'Error!',
                                    content: result.error.message
                                });
                                event.preventDefault();
                                $('#sidebarBackdropCustom').addClass('hide');  
                                return false;
                            }
                        });
                    }   
                },
                stripeTokenHandler: function(stripeResponse, _this){
                    _this.createOrderId(stripeResponse.token.id,stripeResponse.token.client_ip,stripeResponse.token.card.last4,_this);
                },
                createOrderId: function(stripetokenId,clientIp,last4,_this){
                    var email = document.getElementById("email").value;
                    if(checkStoredPaymentScenario()){
                        _this.saveCreditCard(stripetokenId,email,last4,clientIp, _this);
                    }else{
                        _this.processPODPayment(stripetokenId,email,last4,document.getElementById("Check").checked,clientIp,CCRZ.pagevars.currentCartID, _this);
                    }
                },
                saveCreditCard: function(stripetokenId, email,last4,clientIp, _this){
                    _this.model.saveCreditCard(stripetokenId,email,last4,clientIp, function(response, event){
                        if(event.status) {
                            if(response.success) {
                                $.alert({
                                    title: document.getElementById('ccSaveCardSuccessHeading').value,
                                    content: document.getElementById('ccSaveCardSuccessMsg').value
                                });
                                
                                setTimeout(function() {
                                    window.location = 'ccrz__MyAccount?viewState=viewAccount';
                                }, 3000);
                            } else {
                                _this.saveCardError();
                            }
                        } else {
                            _this.saveCardError();
                        }
                    });
                },
                processPODPayment: function(stripetokenId, email,last4,savecard,clientIp, cartId, _this){
                    _this.model.getPaymentToken(stripetokenId,email,last4,savecard,clientIp,cartId, function(response, event){
                        if(event.status) {
                            if(response.success) {
                                $.alert({
                                    title: CCRZ.pagevars.pageLabels.ALTB2B_pod_paymentSuccessTitle,
                                    content: CCRZ.pagevars.pageLabels.ALTB2B_pod_paymentSuccessText,
                                });
                                setTimeout(function() {
                                    CCRZ.pubSub.trigger('action:processPayment', response.data['txObject']);
                                }, 3000);
                            } else {
                                _this.addErrorMsg();
                            }
                        } else {
                            _this.addErrorMsg();
                        }
                    });
                },
                getLatestBillingAddress: function(_this){
                    var billingDetails = {};
                    var input = $('.billinginput input'), select = $('.billinginput select');
                    for(var i = 0; i < input.length; i++) {
                        billingDetails[input[i].id] = input[i].value;
                        if(input[i].id.toLowerCase() == "address_country") {
                            var countryName = input[i].value;
                            if(countryName.toLowerCase() == "united states of america" || countryName.toLowerCase() == "america" || countryName.toLowerCase() == "the states" || countryName.toLowerCase() == "us" || countryName.toLowerCase() == "u.s." || countryName.toLowerCase() == "u.s" || countryName.toLowerCase() == "usa" || countryName.toLowerCase() == "u.s.a." || countryName.toLowerCase() == "u.s.a" || countryName.toLowerCase() == "united states") {
                                countryName = "US";
                            } else {
                                countryName = _this.getCountryISOCode(input[i].value);
                            }
                            billingDetails[input[i].id] = countryName;
                        }
                    }
                    for(var i = 0; i < select.length; i++) {
                        billingDetails[select[i].id] = select[i].value;
                    }
                    billingDetails["name"] = billingDetails["firstname"] + " " + billingDetails["lastname"];
                    delete billingDetails.firstname;
                    delete billingDetails.lastname;
                    return billingDetails;
                },
                addErrorMsg: function(){
                    $.alert({
                        title: CCRZ.pagevars.pageLabels.ALTB2B_pod_paymentErrorTitle,
                        content: CCRZ.pagevars.pageLabels.ALTB2B_pod_paymentErrorText,
                    });
                    $('#sidebarBackdropCustom').addClass('hide');  
                },
                getCountryISOCode: function(){
                    //default value for country
                    var countryName = "US";
                    if(CCRZ.cartCheckoutModel && CCRZ.cartCheckoutModel.attributes.billingAddress.countryList) {
                        var countryList = CCRZ.cartCheckoutModel.attributes.billingAddress.countryList;
                        if(countryList && countryList.length > 0) {
                            for(var i = 0; i < countryList.length; i++) {
                                if(billingCountry.toLowerCase() == countryList[i].label.toLowerCase()) {
                                    countryName = countryList[i].value;
                                    break;
                                }
                            }
                        }
                    }
                    return countryName;
                }
            });
            
            if(checkStoredPaymentScenario()){
                CCRZ.paymentpod = new CCRZ.views.PaymentsPODView({
                    model: paymentModel,
                    selector: CCRZ.uiProperties.StoredPaymentsPOView.desktop.selector
                });
            } else {
                CCRZ.pubSub.trigger('action:paymentViewReady', 'pod', function(options) {
                    //need som info cart ID
                    CCRZ.payment = CCRZ.payment || {
                        views: {}
                    };
                    
                    CCRZ.payment.views.pod = new CCRZ.views.PaymentsPODView({
                        model: paymentModel,
                        selector: options.selector
                    });
                });            
            }
        } 
    }
});